/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Administrador;
import br.com.apifibra.fibrafisio.model.Agenda;
import br.com.apifibra.fibrafisio.model.Evolucao;
import br.com.apifibra.fibrafisio.repository.EvolucaoRepository;
import br.com.apifibra.fibrafisio.service.AdministradorService;
import br.com.apifibra.fibrafisio.service.AgendaService;
import java.security.Principal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agendas"})
public class AgendaController {
    @Autowired
    private AgendaService agendaService;
    @Autowired
    private AdministradorService administradorService;
    @Autowired
    private EvolucaoRepository evolucaoRepository;

    @GetMapping
    public List<Agenda> getAllAgendas() {
        return this.agendaService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Agenda> getAgendaById(@PathVariable Long id) {
        Optional agenda = this.agendaService.findById(id);
        return agenda.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Agenda createAgenda(@RequestBody Agenda agenda) {
        return this.agendaService.save(agenda);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Agenda> updateAgenda(@PathVariable Long id, @RequestBody Agenda agendaDetails) {
        Optional agenda = this.agendaService.findById(id);
        if (agenda.isPresent()) {
            Agenda updatedAgenda = (Agenda)agenda.get();
            updatedAgenda.setData(agendaDetails.getData());
            updatedAgenda.setHorarioInicio(agendaDetails.getHorarioInicio());
            updatedAgenda.setHorarioFim(agendaDetails.getHorarioFim());
            updatedAgenda.setProfissional(agendaDetails.getProfissional());
            updatedAgenda.setPaciente(agendaDetails.getPaciente());
            updatedAgenda.setProcedimento(agendaDetails.getProcedimento());
            updatedAgenda.setEvolucoes(agendaDetails.getEvolucoes());
            updatedAgenda.setStatus(agendaDetails.getStatus());
            updatedAgenda.setValor(agendaDetails.getValor());
            updatedAgenda.setPagamento(agendaDetails.getPagamento());
            updatedAgenda.setFormaPagamento(agendaDetails.getFormaPagamento());
            return ResponseEntity.ok((Object)this.agendaService.save(updatedAgenda));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteAgenda(@PathVariable Long id) {
        if (this.agendaService.findById(id).isPresent()) {
            this.agendaService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/date/{date}"})
    public List<Agenda> getAgendasByDate(@PathVariable String date) {
        System.out.println("'req'");
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate parsedDate = LocalDate.parse(date, formatter);
            return this.agendaService.findByDate(parsedDate);
        }
        catch (DateTimeParseException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @GetMapping(value={"/username/{username}"})
    public ResponseEntity<Administrador> getAdministradorByUsername(@PathVariable String username) {
        Optional administrador = this.administradorService.findByNome(username);
        return administrador.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/paciente/{pacienteId}"})
    public List<Agenda> getAgendasByPacienteId(@PathVariable Long pacienteId) {
        return this.agendaService.findByPacienteId(pacienteId);
    }

    @GetMapping(value={"/profissional/{profissionalId}"})
    public ResponseEntity<List<Agenda>> getAgendasByProfissionalId(@PathVariable Long profissionalId, Principal principal) {
        String adminUsername = principal.getName();
        Optional optionalAdmin = this.administradorService.findByNome(adminUsername);
        if (optionalAdmin.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        Administrador admin = (Administrador)optionalAdmin.get();
        boolean isProfissionalVinculado = admin.getProfissionais().stream().anyMatch(profissional -> profissional.getId().equals(profissionalId));
        if (!isProfissionalVinculado) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        List agendas = this.agendaService.findByProfissionalId(profissionalId);
        return ResponseEntity.ok((Object)agendas);
    }

    @PostMapping(value={"/{id}/evolucoes"})
    public ResponseEntity<Agenda> addEvolucoesToAgenda(@PathVariable Long id, @RequestBody List<Long> evolucaoIds) {
        Optional optionalAgenda = this.agendaService.findById(id);
        if (optionalAgenda.isPresent()) {
            Agenda agenda = (Agenda)optionalAgenda.get();
            List evolucoes = this.evolucaoRepository.findAllById(evolucaoIds);
            agenda.getEvolucoes().addAll(evolucoes);
            return ResponseEntity.ok((Object)this.agendaService.save(agenda));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}/evolucoes/{evolucaoId}"})
    public ResponseEntity<Agenda> removeEvolucaoFromAgenda(@PathVariable Long id, @PathVariable Long evolucaoId) {
        Optional optionalAgenda = this.agendaService.findById(id);
        if (optionalAgenda.isPresent()) {
            Agenda agenda = (Agenda)optionalAgenda.get();
            Evolucao evolucao = this.evolucaoRepository.findById((Object)evolucaoId).orElse(null);
            if (evolucao != null) {
                agenda.getEvolucoes().remove(evolucao);
                return ResponseEntity.ok((Object)this.agendaService.save(agenda));
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }
}

