/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.AuthRequest;
import br.com.apifibra.fibrafisio.util.JwtUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtUtil jwtUtil;

    @PostMapping(value={"/login"})
    public Map<String, String> login(@RequestBody AuthRequest authRequest) {
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)authRequest.getUsername(), (Object)authRequest.getPassword()));
            User user = (User)authentication.getPrincipal();
            String token = this.jwtUtil.generateToken(user.getUsername());
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("token", token);
            return response;
        }
        catch (AuthenticationException e) {
            throw new RuntimeException("Usu\u00e1rio ou senha inv\u00e1lidos");
        }
    }
}

