/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Convenio;
import br.com.apifibra.fibrafisio.model.Procedimento;
import br.com.apifibra.fibrafisio.service.ConvenioService;
import br.com.apifibra.fibrafisio.service.ProcedimentoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/convenios"})
public class ConvenioController {
    @Autowired
    private ConvenioService convenioService;
    @Autowired
    private ProcedimentoService procedimentoService;

    @GetMapping
    public List<Convenio> getAllConvenios() {
        return this.convenioService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Convenio> getConvenioById(@PathVariable Long id) {
        Optional convenio = this.convenioService.findById(id);
        return convenio.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Convenio createConvenio(@RequestBody Convenio convenio) {
        return this.convenioService.save(convenio);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Convenio> updateConvenio(@PathVariable Long id, @RequestBody Convenio convenioDetails) {
        Optional convenio = this.convenioService.findById(id);
        if (convenio.isPresent()) {
            Convenio updatedConvenio = (Convenio)convenio.get();
            updatedConvenio.setDescricao(convenioDetails.getDescricao());
            return ResponseEntity.ok((Object)this.convenioService.save(updatedConvenio));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteConvenio(@PathVariable Long id) {
        if (this.convenioService.findById(id).isPresent()) {
            this.convenioService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/procedimentos"})
    public List<Procedimento> getProcedimentosByConvenio(@PathVariable Long id) {
        return this.procedimentoService.findByConvenioId(id);
    }
}

