/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.service;

import br.com.apifibra.fibrafisio.dto.AdministradorDTO;
import br.com.apifibra.fibrafisio.model.Administrador;
import br.com.apifibra.fibrafisio.repository.AdministradorRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AdministradorService {
    @Autowired
    private AdministradorRepository administradorRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public Administrador save(Administrador administrador) {
        return (Administrador)this.administradorRepository.save((Object)administrador);
    }

    public Administrador save(AdministradorDTO administradorDTO) {
        Administrador administrador = new Administrador();
        administrador.setNome(administradorDTO.getNome());
        administrador.setSenha(this.passwordEncoder.encode((CharSequence)administradorDTO.getSenha()));
        administrador.setMaster(administradorDTO.isMaster());
        administrador.setDescricao(administradorDTO.getDescricao());
        return (Administrador)this.administradorRepository.save((Object)administrador);
    }

    public List<Administrador> findAll() {
        return this.administradorRepository.findAll();
    }

    public Optional<Administrador> findById(Long id) {
        return this.administradorRepository.findById((Object)id);
    }

    public void deleteById(Long id) {
        this.administradorRepository.deleteById((Object)id);
    }

    public String encodePassword(String password) {
        return this.passwordEncoder.encode((CharSequence)password);
    }

    public Optional<Administrador> findByNome(String nome) {
        return this.administradorRepository.findByNome(nome);
    }
}

