/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.service;

import br.com.apifibra.fibrafisio.model.Agenda;
import br.com.apifibra.fibrafisio.model.FormaPagamento;
import br.com.apifibra.fibrafisio.repository.AgendaRepository;
import br.com.apifibra.fibrafisio.repository.EvolucaoRepository;
import br.com.apifibra.fibrafisio.repository.FormaPagamentoRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgendaService {
    @Autowired
    private AgendaRepository agendaRepository;
    @Autowired
    private EvolucaoRepository evolucaoRepository;
    @Autowired
    private FormaPagamentoRepository formaPagamentoRepository;

    public List<Agenda> findAll() {
        return this.agendaRepository.findAll();
    }

    public Optional<Agenda> findById(Long id) {
        return this.agendaRepository.findById((Object)id);
    }

    public Agenda save(Agenda agenda) {
        return (Agenda)this.agendaRepository.save((Object)agenda);
    }

    public void deleteById(Long id) {
        this.agendaRepository.deleteById((Object)id);
    }

    public List<Agenda> findByDate(LocalDate date) {
        return this.agendaRepository.findByData(date);
    }

    public List<Agenda> findByPacienteId(Long pacienteId) {
        return this.agendaRepository.findByPacienteId(pacienteId);
    }

    public List<Agenda> findByProfissionalId(Long profissionalId) {
        return this.agendaRepository.findByProfissionalId(profissionalId);
    }

    public Agenda addEvolucoesToAgenda(Long agendaId, List<Long> evolucaoIds) {
        Optional optionalAgenda = this.agendaRepository.findById((Object)agendaId);
        if (optionalAgenda.isPresent()) {
            Agenda agenda = (Agenda)optionalAgenda.get();
            List evolucoes = this.evolucaoRepository.findAllById(evolucaoIds);
            agenda.setEvolucoes(evolucoes);
            return (Agenda)this.agendaRepository.save((Object)agenda);
        }
        return null;
    }

    public Agenda associateFormaPagamento(Long agendaId, Long formaPagamentoId) {
        Optional optionalAgenda = this.agendaRepository.findById((Object)agendaId);
        Optional optionalFormaPagamento = this.formaPagamentoRepository.findById((Object)formaPagamentoId);
        if (optionalAgenda.isPresent() && optionalFormaPagamento.isPresent()) {
            Agenda agenda = (Agenda)optionalAgenda.get();
            FormaPagamento formaPagamento = (FormaPagamento)optionalFormaPagamento.get();
            agenda.setFormaPagamento(formaPagamento);
            return (Agenda)this.agendaRepository.save((Object)agenda);
        }
        return null;
    }
}

