/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private final Key key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
    private final long expirationTime = 86400000L;

    public String generateToken(String username) {
        return Jwts.builder().setSubject(username).setExpiration(new Date(System.currentTimeMillis() + 86400000L)).signWith(this.key).compact();
    }

    public String extractUsername(String token) {
        return ((Claims)Jwts.parserBuilder().setSigningKey(this.key).build().parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parserBuilder().setSigningKey(this.key).build().parseClaimsJws(token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

